import yaml
from src.simulate_trajs import ProblemEvaluator 
from src.harl import HARLProblem
from src.robot import Robot
from utils.reprod_setup import set_seed
from utils.argparser import cmdline_args
from utils.env_utils import setup_dirs
import sys, os

def parse_yaml(yaml_file):
    with open(yaml_file,"r") as stream:
        config = yaml.safe_load(stream)
        return config

if __name__ == "__main__":
    
    args = cmdline_args()
    config_file = args.config
    runid = args.runid
    seed = args.seed
    abstraction_type = args.abstraction
    if abstraction_type not in ["centroid", "interface"]:
        raise ValueError("Undefined abstraction type {}. Choices: {}".format(abstraction_type, ", ".join(["centroid", "interface"])))
    problem_config = parse_yaml(config_file)

    if problem_config["reset"] and args.mode == "train":
            os.system("rm -rf {}/*".format(problem_config["policy_folder"]))
    
    setup_dirs(problem_config, runid)
    if problem_config.get("sim_robot") is None:
        problem_config["sim_robot"] = problem_config["robot"]
        robot = Robot(problem_config["robot"]["name"],
                    problem_config["robot"]["ndofs"],
                    problem_config["robot"]["llimits"],
                    problem_config["robot"]["ulimits"])
        mp_robot = Robot(problem_config["mp_robot"]["name"],
                    problem_config["mp_robot"]["ndofs"],
                    problem_config["mp_robot"]["llimits"],
                    problem_config["mp_robot"]["ulimits"])

    if args.mode == "train":

        set_seed(seed)
        print("SEED: {}".format(seed))
        print("ROBOT: {}".format(problem_config['robot']['name']))
        print("ENV: {}".format(problem_config['env_name']))
        print("RUNID: {}".format(runid))
        

        hp = HARLProblem(robot,mp_robot,problem_config,runid,seed,abstraction_type)
        hp.generate_and_test()
    elif args.mode == "eval":
        seeds = range(10,210,10)
        pe = ProblemEvaluator(problem_config,robot,mp_robot,runid,seeds,abstraction_type)
        pe.evaluate()